Rem
Rem $Header: enq_xml.sql 11-jul-2003.15:50:00 kbittler Exp $
Rem
Rem enq_xml.sql
Rem
Rem Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      enq_xml.sql - Creates and enqueues a message.
Rem
Rem    DESCRIPTION
Rem      This script creates a message with payload type MGWUSER.BOOK_ORDER_T
Rem      and enqueues it to the queue MGWUSER.MGW_BOOK_SRC.
Rem
Rem    NOTES
Rem

DECLARE
  v_payload   mgwuser.book_order_t;
  v_enq_opts  dbms_aq.enqueue_options_t;
  v_msg_props dbms_aq.message_properties_t;
  v_msgid     RAW(16);

BEGIN
  -- Construct a message of type MGWUSER.BOOK_ORDER_T.
  v_payload := mgwuser.book_order_t(null,null,null,null,null,null,null);
  v_payload.order_no := 3;
  v_payload.book_name := 'The Java Programming Language';
  v_payload.book_isbn := '0-201-63455-4';
  v_payload.book_amount := 2;
  v_payload.payment := 'VISA 0000 1111 2222 3333 4444';
  v_payload.ship_addr := '1000 Broadway, Porland, OR 97201';
  v_payload.order_date := DATE '2002-1-1';

  -- Enqueue the message.
  dbms_aq.enqueue('mgwuser.mgw_book_src', v_enq_opts, v_msg_props, v_payload, v_msgid);
  commit;
END;
/

